﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.ComponentModel" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Place" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ import Namespace="Soneta.Business.Db" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Deklaracja ZUS Z-3a</title>
		<script runat="server">

            public class PrnParams: Soneta.Business.ContextBase {

                public readonly Nieobecnosc Nieobecność;
                public readonly ArrayList Nieobecności = new ArrayList();

                void LoadNieobecnosci() {
                    Nieobecności.Add(Nieobecność);

                    KalkulatorPracy kal = new KalkulatorPracy(Nieobecność.Pracownik);
                    ArrayList lst = new ArrayList((ICollection)kal.Nieobecnosci(new FromTo(Date.MinValue, Nieobecność.Okres.From-1), true));
                    lst.Reverse();
                    INieobecnosc prev = Nieobecność;
                    foreach (INieobecnosc n in lst)
                        if (n.Definicja.Typ == TypNieobecnosci.NieobecnośćZUS)
                            if (Kontynuacja(prev, n)) {
                                Nieobecności.Add(n);
                                prev = n;
                            }
                            else
                                break;

                    Nieobecności.Reverse();
                    Początek = prev.Okres.From;
                }

                bool Kontynuacja(INieobecnosc current, INieobecnosc prev) {
                    YearMonth cm = new YearMonth(current.Okres.From);
                    YearMonth pm = new YearMonth(prev.Okres.To);

                    int c = cm - pm;
                    c -= 1;

                    return c < 3;//Podstawę przeliczamy jeżeli pomiędzy końcem poprzedniej a początkiem 
                                 //nastepnej nieobecności ZUS muszą są co najmniej 3 pełne miesiące kalendarzoe
                }

                public FromTo OkresZatrudnienia() {
                    if (początek == Date.Empty)
                        return FromTo.Empty;
                    FromTo okres = Nieobecność.Pracownik[początek].Etat.OkresZatrudnienia;
                    if (okres.From.Day > 1 && DniPracyDo(Nieobecność.Pracownik, okres.From-1)>0)   //TID: 23589
                        okres *= new FromTo((new YearMonth(okres.From) + 1).FirstDay, Date.MaxValue);
                    if (okres == FromTo.Empty) {
                        okres = OkresZatr(Nieobecność.Pracownik, początek);
                        if (okres.From.Day > 1)
                            okres *= new FromTo((new YearMonth(okres.From) + 1).FirstDay, Date.MaxValue);
                    }
                    return okres;
                }

                public FromTo OkresZatrudnieniaRok() {
                    return OkresZatrudnienia() * new FromTo(new Date(Nieobecność.Okres.From.Year, 1, 1), Date.MaxValue);
                }

                private bool Wypadek() {
                    return Nieobecność.Zwolnienie.Przyczyna == PrzyczynaZwolnienia.WypadekPrzyPracyLubChorobaZawodowa;
                }

                private FromTo OkresUbezpieczenia() {
                    if (Wypadek())
                        return FromTo.All;

                    Pracownik pracownik = Nieobecność.Pracownik;
                    Date ubchOd = Date.Empty, ubchDo = Date.Empty;
                    Date data = Nieobecność.Okres.From;

                    Date ub;
                    bool umowa = false;
                    FromTo okres = FromTo.Empty;
                    Soneta.Business.View v = pracownik.Umowy.CreateView();
                    v.Sort = "Okres";
                    foreach (Umowa um in v) {
                        if (um.Okres.Contains(data))
                            umowa = true;
                        if (okres != FromTo.Empty && um.Okres.From.AddDays(-1) <= okres.To) {
                            okres = new FromTo(okres.From, um.Okres.To);
                            foreach (UmowaHistoria uh in um.Historia) {
                                ub = uh.Ubezpieczenia.Chorobowe.DobrowolneOd;
                                if (ub == Date.Empty || ub.AddDays(-1) > ubchDo)
                                    ubchOd = ub;
                                ubchDo = uh.Ubezpieczenia.Chorobowe.Do;
                            }
                        }
                        else {
                            if (okres == FromTo.Empty || !umowa) {
                                okres = um.Okres;
                                foreach (UmowaHistoria uh in um.Historia) {
                                    ub = uh.Ubezpieczenia.Chorobowe.DobrowolneOd;
                                    if (ub == Date.Empty || ub.AddDays(-1) > ubchDo)
                                        ubchOd = ub;
                                    ubchDo = uh.Ubezpieczenia.Chorobowe.Do;
                                }
                            }
                            else
                                break;
                        }
                    }

                    okres = FromTo.Empty;
                    if (umowa) {
                        okres = new FromTo(ubchOd, ubchDo);
                        if (ubchOd.Day > 1)
                            okres *= new FromTo((new YearMonth(okres.From) + 1).FirstDay, Date.MaxValue);
                    }

                    return okres;
                }

                public PrnParams(Context context): base(context) {
                    Nieobecność = (Nieobecnosc)context[typeof(Nieobecnosc)];
                    LoadNieobecnosci();
                    ubezpieczeni = new Date(Początek.Year-1, 11, 30);
                }

                Date początek;
                [Required]
                [Priority(10)]
                [Caption("Okres zasiłkowy od")]
                public Date Początek {
                    get { return początek; }
                    set {
                        początek = value;
                        int delta = początek<new Date(2005, 2, 8) ? 5 : 11;
                        YearMonth to = new YearMonth(początek)-1;
                        YearMonth from = to - delta;
                        okres = new FromTo(from.FirstDay, to.LastDay) * OkresZatrudnienia() * OkresUbezpieczenia();
                        OnChanged(EventArgs.Empty);
                    }
                }

                FromTo okres;
                [Required]
                [Priority(20)]
                [Caption("Okresy miesięczne")]
                public FromTo Okres {
                    get { return okres; }
                    set {
                        okres = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                FromTo okresowe;
                [Priority(30)]
                [Caption("Pozostałe okresy")]
                public FromTo Okresowe {
                    get {
                        if (okres == FromTo.Empty)
                            return FromTo.Empty;
                        YearMonth to = new YearMonth(okres.To);
                        YearMonth from = to - 11;
                        return new FromTo(from.FirstDay, to.LastDay) * OkresZatrudnienia();
                    }
                }

                Date ubezpieczeni;
                [Priority(40)]
                [Caption("Ubezpieczeni na dzień")]
                public Date Ubezpieczeni {
                    get { return ubezpieczeni; }
                    set {
                        ubezpieczeni = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                [Browsable(false)]
                public FromTo OkresZasiłkowy {
                    get { return new FromTo(początek, Nieobecność.Okres.To); }
                }
            }

            static Set<string> nieWliczaneDoPodstawy = new Set<string>();

            static TypPodstawyZasilku GetZasilkiTyp(WypElement e) {
                TypPodstawyZasilku t = e.Definicja.Nieobecnosci.ZasilkiPracownicy.Typ;
                if (t != 0)
                    return t;
                //Nie stanowi podstawy zasiłki (to oczywiste)
                //Stanowi podstawę naliczania składek ZUS

                if (e.Definicja.Deklaracje.Spoleczne.Typ == TypUbezpieczeniaSpolecznego.NieNaliczać)
                    return TypPodstawyZasilku.NieWliczać;

                return TypPodstawyZasilku.WliczaćDla;
            }

            PrnParams pars;
            [Soneta.Business.Context(Required=true)]
            public PrnParams Params {
                set {
                    pars = value;
                }
            }

            static FromTo OkresZatr(Pracownik pracownik, Date data) {
                bool umowa = false;
                FromTo okres = pracownik[data].Etat.OkresZatrudnienia;
                if (okres != FromTo.Empty)
                    return okres;
                Soneta.Business.View v = pracownik.Umowy.CreateView();
                v.Sort = "Okres";
                foreach (Umowa um in v) {
                    if (um.Okres.Contains(data))
                        umowa = true;
                    if (okres != FromTo.Empty && um.Okres.From.AddDays(-1) <= okres.To)
                        okres = new FromTo(okres.From, um.Okres.To);
                    else {
                        if (okres == FromTo.Empty || !umowa)
                            okres = um.Okres;
                        else
                            break;
                    }
                }
                return umowa ? okres : FromTo.Empty;
            }

            class PodstawaSkładek {

                readonly protected Pracownik pracownik;
                readonly FromTo okres;
                Date dataSkładek = Date.MaxValue;
                TytulUbezpieczenia tyub = TytulUbezpieczenia.Empty;
                public PodstawaSkładek(Pracownik pracownik, FromTo okres) {
                    this.pracownik = pracownik;
                    this.okres = okres;
                }

                protected void AddElement(WypElement element, TypPodstawyZasilku t) {
                    if (t != 0) {
                        if (tyub == TytulUbezpieczenia.Empty && element.Podatki.TyUb != TytulUbezpieczenia.Empty)
                            tyub = element.Podatki.TyUb;
                        if (element.Data < dataSkładek)
                            dataSkładek = element.Data;
                    }
                }
            }

            class SumMiesiąc : PodstawaSkładek, IComparable {
                readonly YearMonth ym;
                readonly int norma;
                readonly int praca;
                decimal faktyczne;
                Hashtable nieobecnosci = new Hashtable();
                decimal wspDopełnienia = 1m;

                Set<WypSkladnik> uwzględnoneSkładniki = new Set<WypSkladnik>();
                decimal WartośćPomniejszenia(WypSkladnik skl, bool bezPomnZus) {
                    if (!(skl is WypSkladnikPomniejszenie) && !(skl is WypSkladnikStorno))
                        throw new ArgumentException("Oczekiwany składnik typu pomniejszenie zamiast " + skl.GetType() + ".");
                    if (uwzględnoneSkładniki.Contains(skl))
                        return 0;
                    uwzględnoneSkładniki.Add(skl);

                    //TID: 9873
                    Nieobecnosc n = skl.Nieobecnosc;
                    if (n != null && n.Definicja.Typ == TypNieobecnosci.Storno)
                        n = n.Zrodlo as Nieobecnosc;

                    //if (n != null && n.Definicja.Typ == TypNieobecnosci.NieobecnośćZUS)
                    if (n != null && n.Definicja.Typ == TypNieobecnosci.NieobecnośćZUS && bezPomnZus)     //TID: 11407
                        return 0;
                    return skl.Wartosc;
                }

                decimal WartośćElementu(WypElement e) {
                    decimal w = 0;
                    foreach (WypSkladnik s in e.Skladniki)
                        if (s is WypSkladnikPomniejszenie || s is WypSkladnikStorno)
                            w += WartośćPomniejszenia(s, false);     //TID: 11407
                        else
                            w += s.Wartosc;
                    return w;
                }

                public SumMiesiąc(Pracownik pracownik, YearMonth ym)
                    : base(pracownik, ym.ToFromTo()) {
                    this.ym = ym;

                    FromTo okres = ym.ToFromTo();
                    FromTo oz = okres * OkresZatr(pracownik, okres.To);
                    norma = pracownik.Czasy.Norma(oz).Dni
                        - pracownik.Czasy.KalkPracy.NormaNie(oz, Nieobecnosc.Nieusprawiedliwiona).Dni;

                    praca = pracownik.Czasy.Praca(oz, Dzien.Pracy, AlgorytmyPłacowe.OR, Dzien.Zestawienie).Dni
                        + pracownik.Czasy.KalkPracy.NormaNie(oz, Nieobecnosc.UsprawiedliwionaPłatna).Dni;

                    //TID: 19896
                    if (oz != okres) {
                        Time normaOz = pracownik.Czasy.Norma(oz).Czas;
                        Time normaMies = pracownik.Czasy.Norma(okres).Czas;
                        if (normaOz!=Time.Zero)
                            wspDopełnienia = (decimal)normaMies.TotalMinutes / normaOz.TotalMinutes;
                    }
                }
                public int CompareTo(object obj) {
                    if (obj == null)
                        return 1;
                    SumMiesiąc sm = obj as SumMiesiąc;
                    if (sm == null)
                        throw new ArgumentException();
                    return ym.CompareTo(sm.Miesiąc);
                }
                public void Add(WypElement e) {
                    bool godzinowa = false;
                    TypPodstawyZasilku t = GetZasilkiTyp(e);
                    AddElement(e, t);

                    switch (t) {
                        case TypPodstawyZasilku.WliczaćDla:
                            faktyczne += WartośćElementu(e);                //TID: 8873
                            break;
                        case TypPodstawyZasilku.DopełniaćWedługGodzinDla:
                        case TypPodstawyZasilku.DopełniaćWedługDniDla:
                            LiczProporcjonalne(e, godzinowa);
                            break;
                        case TypPodstawyZasilku.DopełniaćJakZasadniczeDla:
                            if (godzinowa)
                                LiczProporcjonalne(e, godzinowa);
                            else
                                LiczZasadnicze(e, godzinowa);
                            break;
                        case TypPodstawyZasilku.WliczaćWNominalnejWysokościDla:
                            LiczZasadnicze(e, godzinowa);
                            break;
                    }

                    if (e.Definicja.Nieobecnosci.ZasilkiPracownicy.Typ == 0 && t == TypPodstawyZasilku.WliczaćDla && e.Wartosc!=0)
                        nieWliczaneDoPodstawy.Add(e.Definicja.Nazwa);
                }

                //TID: 5538
                bool UwzględniajPomniejszenie(WypElement e, bool godzinowa) {
                    TypPodstawyZasilku t = GetZasilkiTyp(e);

                    //TID: 8614
                    if (t == TypPodstawyZasilku.NieWliczać)
                        return false;

                    //TID: 8737
                    if (t == TypPodstawyZasilku.WliczaćDla)
                        return false;

                    if (godzinowa)
                        switch (t) {
                            case TypPodstawyZasilku.DopełniaćWedługGodzinDla:
                            case TypPodstawyZasilku.DopełniaćWedługDniDla:
                            case TypPodstawyZasilku.DopełniaćJakZasadniczeDla:
                                return false;
                        }

                    return true;
                }

                void LiczProporcjonalne(WypElement e, bool godzinowa) {
                    //proporcjonalne += e.Wartosc;               
                    Nieobecnosc nieobecność = e is WypElementNieobecność || e is WypElementStorno ? (Nieobecnosc)e.BazaZrodla : null;
                    decimal wartośćNominalna = e.WartośćNominalna;
                    if (nieobecność == null) {
                        wartośćNominalna *= wspDopełnienia;                                 //TID: 19896
                        if (wspDopełnienia!=1m && e is WypElementEtat) {                    //TID: 19896.2
                            var stawka = ((Currency)AlgorytmyPłacowe.ZasadniczeNominalne(e.Pracownik, e.Okres.To)).Value;       //TID: 19896.2
                            if (System.Math.Abs(stawka - wartośćNominalna)<1m)
                                wartośćNominalna = stawka;
                        }
                        //proporcjonalne += wartośćNominalna;
                        decimal f = 0;
                        decimal p = 0;
                        foreach (WypSkladnik s in e.Skladniki)
                            if (s is WypSkladnikOdchyłka)
                                if (s is WypSkladnikOdchyłka.AkordMinus && godzinowa)  //TID: 9837
                                    p += s.Wartosc;
                                else
                                    f += s.Wartosc;
                            else if (s is WypSkladnikPomniejszenie || s is WypSkladnikStorno)
                                p += WartośćPomniejszenia(s, false);            //TID: 8873
                        faktyczne += f;
                        //proporcjonalne += p;
                    }
                    //else if (nieobecność.Definicja.Typ != TypNieobecnosci.UsprawiedliwionaPłatna)
                    //    proporcjonalne += wartośćNominalna;
                    else {
                        decimal p = wartośćNominalna;
                        //if (Podstawowy(e))  //TID: 8664 --> zamiast tego jest poprawka 8873
                        foreach (WypSkladnik s in nieobecność.Pomniejszenia)
                            if (e.Okres.Contains(s.Okres.To) && UwzględniajPomniejszenie(s.Element, godzinowa))
                                if (s is WypSkladnikPomniejszenie || s is WypSkladnikStorno)      //TID: 9734
                                    p += WartośćPomniejszenia(s, true);            //TID: 8873
                        //TID: 
                        //faktyczne += k;
                        //proporcjonalne += p;
                    }
                }

                void LiczZasadnicze(WypElement e, bool godzinowa) {
                    Nieobecnosc nieobecność = e is WypElementNieobecność || e is WypElementStorno ? (Nieobecnosc)e.BazaZrodla : null;
                    decimal wartośćNominalna = e.WartośćNominalna;
                    if (nieobecność == null) {
                        wartośćNominalna *= wspDopełnienia;                                 //TID: 19896
                        if (wspDopełnienia!=1m && e is WypElementEtat) {                    //TID: 19896.2
                            var stawka = ((Currency)AlgorytmyPłacowe.ZasadniczeNominalne(e.Pracownik, e.Okres.To)).Value;
                            if (System.Math.Abs(stawka - wartośćNominalna)<1m)
                                wartośćNominalna = stawka;
                        }
                        faktyczne += wartośćNominalna;
                        decimal z = 0;
                        decimal f = 0;
                        decimal p = 0;
                        foreach (WypSkladnik s in e.Skladniki)
                            if (s is WypSkladnikOdchyłka)
                                if (s is WypSkladnikOdchyłka.AkordMinus && !godzinowa) //TID: 8731
                                    faktyczne += s.Wartosc;
                                //else if (s is WypSkladnikPomniejszenie)
                                //    f += WartośćPomniejszenia(s);            //TID: 8873
                                else
                                    f += s.Wartosc;
                            else if (s is WypSkladnikPomniejszenie || s is WypSkladnikStorno)
                            {
                                decimal we = WartośćPomniejszenia(s, true);            //TID: 8873
                                if (s.Nieobecnosc != null && s.Nieobecnosc.Definicja.Rozliczenie == RozliczenieNieobecnosci.Brak) //TID: 
                                    z += 0;     //wysyłamy zero
                                else
                                    p += we;
                            }
                        faktyczne += z;
                        faktyczne += f;
                        //proporcjonalne += p;
                    }
                    else if (nieobecność.Definicja.Typ != TypNieobecnosci.UsprawiedliwionaPłatna)
                        faktyczne += wartośćNominalna;
                    else {
                        decimal p = wartośćNominalna;
                        //if (Podstawowy(e))  //TID: 8664 --> zamiast tego jest poprawka 8873
                        foreach (WypSkladnik s in nieobecność.Pomniejszenia)
                            if (e.Okres.Contains(s.Okres.To) && UwzględniajPomniejszenie(s.Element, godzinowa))
                                if (s is WypSkladnikPomniejszenie || s is WypSkladnikStorno)      //TID: 9734
                                    p += WartośćPomniejszenia(s, true);            //TID: 8873
                        //TID: 
                        //faktyczne += k;
                        //proporcjonalne += p;
                    }
                }

                public YearMonth Miesiąc {
                    get { return ym; }
                }
                public int Norma {
                    get { return norma; }
                }
                public int Praca {
                    get { return praca; }
                }
                public decimal Faktyczne {
                    get {
                        if (nieobecnosci != null) {
                            foreach (decimal d in nieobecnosci.Values)
                                if (d > 0m)
                                    faktyczne += d;
                            nieobecnosci = null;
                        }
                        return faktyczne;
                    }
                }
            }

            class SumOkresowy {
                readonly int norma;
                readonly int praca;
                decimal brutto;
                decimal zus;

                protected SumOkresowy(WypElement e) {
                    //TID: 5878               
                    bool bb = e.Definicja.Nieobecnosci.ZasilkiPracownicy.Typ != TypPodstawyZasilku.NieWliczać;
                    if (bb) {
                        brutto += e.Wartosc;
                        zus += e.Podatki.KosztyZUS;

                        KalkulatorPracownika kalk = new KalkulatorPracownika(e.Pracownik);
                        FromTo okres = e.Okres;
                        norma = kalk.Norma(okres).Dni;

                        FromTo oz = okres * OkresZatr(e.Pracownik, okres.To);
                        praca = kalk.Praca(oz).Dni + kalk.KalkPracy.NormaNie(oz, Nieobecnosc.UsprawiedliwionaPłatna).Dni;
                    }
                }
                public decimal Kwota {
                    get { return brutto; }
                }
                public int Norma {
                    get { return norma; }
                }
                public int Praca {
                    get { return praca; }
                }
            }

            class SumKwartał: SumOkresowy, IComparable {
                readonly YearMonth ym;
                public SumKwartał(WypElement e): base(e) {
                    ym = new YearMonth(e.Okres.To.Year, (e.Okres.To.Month-1)/3 + 1);
                }
                public int CompareTo(object obj) {
                    if (obj==null)
                        return 1;
                    SumKwartał sk = obj as SumKwartał;
                    if (sk==null)
                        throw new ArgumentException();
                    return ym.CompareTo(sk.ym);
                }
                public int Rok {
                    get { return ym.Year; }
                }
                public int Kwartał {
                    get { return ym.Month; }
                }
            }

            class SumRok: SumOkresowy, IComparable {
                readonly int rok;
                public SumRok(WypElement e): base(e) {
                    rok = e.Okres.To.Year;
                }
                public int CompareTo(object obj) {
                    if (obj==null)
                        return 1;
                    SumRok sr = obj as SumRok;
                    if (sr==null)
                        throw new ArgumentException();
                    return rok.CompareTo(sr.Rok);
                }
                public int Rok {
                    get { return rok; }
                }
            }

            class SumInne: SumOkresowy, IComparable {
                readonly FromTo okres;
                public SumInne(WypElement e): base(e) {
                    okres = e.Okres;
                }
                public int CompareTo(object obj) {
                    if (obj==null)
                        return 1;
                    SumInne si = obj as SumInne;
                    if (si==null)
                        throw new ArgumentException();
                    return okres.CompareTo(si.Okres);
                }
                public FromTo Okres {
                    get { return okres; }
                }
            }

            static int RodzajOkresu(FromTo okres) {
                YearMonth from = new YearMonth(okres.From);
                YearMonth to = new YearMonth(okres.To);
                return to - from + 1;
            }

            IEnumerable LiczMiesiące(Pracownik pracownik, IEnumerable elementy) {
                Hashtable ht = new Hashtable();
                foreach (WypElement e in elementy) {
                    YearMonth ym = new YearMonth(e.Okres.To);
                    SumMiesiąc m = (SumMiesiąc)ht[ym];
                    if (m==null) {
                        m = new SumMiesiąc(pracownik, ym);
                        ht.Add(ym, m);
                    }
                    m.Add(e);
                }
                ArrayList al = new ArrayList(ht.Values);
                al.Sort();
                return al;
            }

            string NBSP(string ss) {
                return ss=="" ? "&nbsp;" : ss;
            }

            void LiczDaneFirmy(PracHistoria ph) {
                CoreModule core = CoreModule.GetInstance(dc);
                string nip = core.Config.Firma.Pieczątka.NIP;
                string regon = core.Config.Firma.Pieczątka.REGON;
                string nazwask = core.Config.Firma.Pieczątka.NazwaSkrócona;
                string nazwisko = core.Config.Firma.DaneEwidencyjne.Nazwisko;
                string imie = core.Config.Firma.DaneEwidencyjne.Imię;
                string kodp = core.Config.Firma.AdresSiedziby.KodPocztowyS;
                string poczta = core.Config.Firma.AdresSiedziby.Poczta;
                string gmina = core.Config.Firma.AdresSiedziby.Gmina;
                string miejscowosc = core.Config.Firma.AdresSiedziby.Miejscowosc;
                string ulica = core.Config.Firma.AdresSiedziby.Ulica;
                string dom = core.Config.Firma.AdresSiedziby.NrDomu;
                string lokal = core.Config.Firma.AdresSiedziby.NrLokalu;
                string tel = core.Config.Firma.AdresSiedziby.Telefon;
                string symbol = core.Config.Firma.AdresSiedziby.KodKraju;
                string kodz = core.Config.Firma.AdresSiedziby.ZagranicznyKodPocztowy;
                string panstwo = core.Config.Firma.AdresSiedziby.Kraj;
                if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
                    OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
                    if (!string.IsNullOrEmpty(of.Deklaracje.NIP)) nip = of.Deklaracje.NIP;
                    if (!string.IsNullOrEmpty(of.Deklaracje.REGON)) regon = of.Deklaracje.REGON;
                    if (!string.IsNullOrEmpty(of.NazwaSkrocona)) nazwask = of.NazwaSkrocona;
                    if (!string.IsNullOrEmpty(of.Adres.KodPocztowyS)) kodp = of.Adres.KodPocztowyS;
                    if (!string.IsNullOrEmpty(of.Adres.Poczta)) poczta = of.Adres.Poczta;
                    if (!string.IsNullOrEmpty(of.Adres.Gmina)) gmina = of.Adres.Gmina;
                    if (!string.IsNullOrEmpty(of.Adres.Miejscowosc)) miejscowosc = of.Adres.Miejscowosc;
                    if (!string.IsNullOrEmpty(of.Adres.Ulica)) ulica = of.Adres.Ulica;
                    if (!string.IsNullOrEmpty(of.Adres.NrDomu)) dom = of.Adres.NrDomu;
                    if (!string.IsNullOrEmpty(of.Adres.NrLokalu)) lokal = of.Adres.NrLokalu;
                    if (!string.IsNullOrEmpty(of.Adres.Telefon)) tel = of.Adres.Telefon;
                    if (!string.IsNullOrEmpty(of.Adres.KodKraju)) symbol = of.Adres.KodKraju;
                    if (!string.IsNullOrEmpty(of.Adres.ZagranicznyKodPocztowy)) kodz = of.Adres.ZagranicznyKodPocztowy;
                    if (!string.IsNullOrEmpty(of.Adres.Kraj)) panstwo = of.Adres.Kraj;
                }

                FirmaNIP.EditValue = NBSP(nip.Replace("-", ""));
                FirmaREGON.EditValue = NBSP("");
                FirmaPESEL.EditValue = NBSP("");
                FirmaRodzaj.EditValue = NBSP("");
                FirmaDokument.EditValue = NBSP("");
                if (!string.IsNullOrEmpty(nazwask))
                    FirmaNazwa.EditValue = NBSP(nazwask.ToUpper());
                else
                    FirmaNazwa.EditValue = NBSP(imie.ToUpper()) + NBSP(nazwisko.ToUpper());
                FirmaKodP.EditValue = NBSP(kodp);
                ///        POCZTA.EditValue = NBSP(poczta);
                ///        GMINA.EditValue = NBSP(gmina);
                FirmaMiejscowosc.EditValue = NBSP(miejscowosc.ToUpper());
                FirmaUlica.EditValue = NBSP(ulica.ToUpper());
                FirmaNrDomu.EditValue = NBSP(dom);
                FirmaNrLokalu.EditValue = NBSP(lokal);
                ///        TEL.EditValue = NBSP(tel);
                ///        SYMBOL.EditValue = NBSP(symbol);
                ///        KODZ.EditValue = NBSP(kodz);
                FirmaKraj.EditValue = NBSP(panstwo.ToUpper());
                ///        MAIL.EditValue = NBSP("");

                if (regon!="")
                    FirmaREGON.EditValue = NBSP(regon);
                if (nip=="" || regon=="")
                    if (core.Config.Firma.DaneEwidencyjne.OsobaFizyczna) {
                        string pesel = core.Config.Firma.DaneEwidencyjne.PESEL;
                        if (pesel=="") {
                            Wlasciciel wls = DeklaracjeModule.GetInstance(dc).Config.ZUS.Ogólne.DaneWłaściciela;
                            if (wls!=null) {
                                pesel = NBSP(wls.Last.PESEL);
                                if (pesel=="") {
                                    FirmaRodzaj.EditValue = NBSP(""); //wls.Last.Dokument.Rodzaj == KodRodzajuDokumentu.DowodOsobisty ? "1" : "2");
                                    FirmaDokument.EditValue = NBSP(wls.Last.Dokument.SeriaNumer.ToUpper());
                                }
                            }
                        }
                        if (pesel!="")
                            FirmaPESEL.EditValue = NBSP(pesel);
                    }
            }

            string Przekreśl(string tekst) {
                string przekreślOn = "<font style=\"text-decoration: line-through\">";
                string przekreślOff = "</font>";
                return przekreślOn + tekst + przekreślOff;
            }

            static int DniPracyDo(Pracownik pracownik, Date data) {
                var kp = new KalkulatorPlanu(pracownik);
                var okres = new FromTo(data.ToYearMonth().FirstDay, data);
                return kp.Norma(okres).Dni;
            }

            void LiczDanePracownika(PracHistoria ph) {
                PracImie.EditValue = ph.Imie.ToUpper();
                PracNazwisko.EditValue = ph.Nazwisko.ToUpper();

                bool dowod = ph.Dokument.Rodzaj == KodRodzajuDokumentu.DowodOsobisty;
                if (ph.NIP == "" || ph.PESEL == "") {
                    //DOKRODZAJ.EditValue = dowod ? "1" : "2";
                    DOKUBEZP.EditValue = ph.Dokument.SeriaNumer.ToUpper();
                }
                else {
                    //DOKRODZAJ.EditValue = NBSP("");
                    DOKUBEZP.EditValue = NBSP("");
                }
                Date ur = ph.Urodzony.Data;
                /// if (ur != Date.Empty) URODZONY.EditValue = string.Format("{0}/{1}/{2}", ur.Day.ToString("D2"), ur.Month.ToString("D2"), ur.Year.ToString("D2"));
                IAdres adres = !ph.AdresZamieszkania.IsEmpty() ? ph.AdresZamieszkania : ph.AdresZameldowania;
                AdresKodPocztowyS.EditValue = adres.KodPocztowyS;
                //AdresPoczta.EditValue = adres.Poczta;
                //AdresGmina.EditValue = adres.Gmina;
                AdresMiejscowosc.EditValue = adres.Miejscowosc.ToUpper();
                AdresUlica.EditValue = adres.Ulica.ToUpper();
                AdresNrDomu.EditValue = adres.NrDomu;
                AdresNrLokalu.EditValue = adres.NrLokalu;
                //AdresKodKraju.EditValue = adres.KodKraju;
                //AdresZagranicznyKodPocztowy.EditValue = adres.ZagranicznyKodPocztowy;
                AdresKraj.EditValue = adres.Kraj.ToUpper();
            }

            static readonly string Blank = "&nbsp;";
            static readonly string Empty = "&nbsp;";
            string FormatDate(Date dt, string str) {
                if (dt == Date.MinValue || dt == Date.MaxValue || dt == Date.Empty)
                    return string.Empty;
                return string.Format("{0} {1}", str, dt);
            }

            void LiczOkresyUbezpieczenia(Nieobecnosc nieobecnosc, PracHistoria ph) {
                Pracownik pracownik = ph.Pracownik;
                Date data = nieobecnosc.Okres.From;
                Date ubchOd = Date.Empty, ubchDo = Date.Empty;
                Date ubwpOd = Date.Empty, ubwpDo = Date.Empty;
                Date dobrDo = Date.Empty;
                bool ubch = false, ubwp = false;
                string str;

                /// string strTak = "tak/" + Przekreśl("nie");
                /// string strNie = Przekreśl("tak") + "/nie";

                Date ub;
                bool umowa = false;
                FromTo okres = FromTo.Empty;
                List<Umowa> umowy = new List<Umowa>();
                Soneta.Business.View v = pracownik.Umowy.CreateView();
                v.Sort = "Okres";
                foreach (Umowa um in v) {
                    if (um.Okres.Contains(data))
                        umowa = true;
                    if (okres != FromTo.Empty && um.Okres.From.AddDays(-1) <= okres.To) {
                        okres = new FromTo(okres.From, um.Okres.To);
                        foreach (UmowaHistoria uh in um.Historia) {
                            ub = uh.Ubezpieczenia.Chorobowe.DobrowolneOd;
                            if (ub == Date.Empty || ub.AddDays(-1) > ubchDo) {
                                dobrDo = ub != Date.Empty ? ub : data;
                                ubchOd = ub;
                            }
                            ubchDo = uh.Ubezpieczenia.Chorobowe.Do;
                            ub = uh.Ubezpieczenia.Wypadkowe.ObowiazkoweOd;
                            if (ub == Date.Empty || ub.AddDays(-1) > ubwpDo)
                                ubwpOd = ub;
                            ubwpDo = uh.Ubezpieczenia.Wypadkowe.Do;
                        }
                    }
                    else {
                        if (okres == FromTo.Empty || umowa) {
                            okres = um.Okres;
                            foreach (UmowaHistoria uh in um.Historia) {
                                ub = uh.Ubezpieczenia.Chorobowe.DobrowolneOd;
                                if (ub == Date.Empty || ub.AddDays(-1) > ubchDo)
                                    ubchOd = ub;
                                ubchDo = uh.Ubezpieczenia.Chorobowe.Do;
                                dobrDo = ub != Date.Empty ? ub : data;
                                ub = uh.Ubezpieczenia.Wypadkowe.ObowiazkoweOd;
                                if (ub == Date.Empty || ub.AddDays(-1) > ubwpDo)
                                    ubwpOd = ub;
                                ubwpDo = uh.Ubezpieczenia.Wypadkowe.Do;
                            }
                        }
                        else
                            break;
                    }
                    umowy.Add(um);
                }

                if (!umowa) {
                    AKTUALNE_OKRESY_CHR.EditValue = Blank;
                    AKTUALNE_OKRESY_CHR_UBEZP_TAK.EditValue = Blank;
                    AKTUALNE_OKRESY_CHR_UBEZP_NIE.EditValue = Blank;
                    AKTUALNE_OKRESY_CHR_TYTUL.EditValue = Blank;
                    AKTUALNE_OKRESY_WYP.EditValue = Blank;
                    /// POPRZEDNIE_OKRESY_CHR.EditValue = Blank;
                }
                else {
                    if (ubchDo != Date.Empty && ubchDo != Date.MaxValue) ubchDo--;
                    str = FormatDate(ubchOd, "") + FormatDate(ubchDo, "-");
                    if (str.Length == 0)
                        str = Blank;
                    AKTUALNE_OKRESY_CHR.EditValue = str;
                    ubch = pars.Początek >= ubchOd && pars.Początek <= ubchDo;
                    ubwp = pars.Początek >= ubwpOd && pars.Początek <= ubwpDo;
                    bool ubs = (ubchDo != Date.Empty && ubchDo != Date.MaxValue);
                    AKTUALNE_OKRESY_CHR_UBEZP_TAK.EditValue = ubs ? "X" : "&nbsp;"; 
                    AKTUALNE_OKRESY_CHR_UBEZP_NIE.EditValue = !ubs ? "X" : "&nbsp;";
                    bool ubd = (ubchDo != Date.Empty && ubchDo != Date.MaxValue);
                    AKTUALNE_OKRESY_CHR_TYTUL.EditValue = ubd ? ubchDo.ToString() : "&nbsp;";
                    if (ubwpDo != Date.Empty && ubwpDo != Date.MaxValue) ubwpDo--;
                    str = FormatDate(ubwpOd, "") + FormatDate(ubwpDo, "-");
                    if (str.Length == 0)
                        str = Blank;
                    AKTUALNE_OKRESY_WYP.EditValue = str;
                    str = string.Empty;
                    Date prev = Date.Empty;
                    foreach (Umowa um in umowy)
                        foreach (UmowaHistoria uh in um.Historia) {
                            Date dobrowolneOd = uh.Ubezpieczenia.Chorobowe.DobrowolneOd;
                            if (dobrowolneOd != Date.Empty && dobrowolneOd >= dobrDo)
                                break;
                            if (dobrowolneOd != Date.Empty && dobrowolneOd != prev) {
                                Date ubchUDo = uh.Ubezpieczenia.Chorobowe.Do;
                                if (ubchUDo != Date.Empty && ubchUDo != Date.MaxValue) ubchUDo--;
                                str += "- " + FormatDate(dobrowolneOd, "") +
                                    FormatDate(ubchUDo, "-") + "<br/>";
                                prev = dobrowolneOd;
                            }
                        }
                    if (str.Length == 0)
                        str = Blank;
                    /// POPRZEDNIE_OKRESY_CHR.EditValue = str;
                }

                UbezpChorTak.EditValue = ubch ? "X" : "&nbsp;";
                UbezpChorNie.EditValue = !ubch ? "X": "&nbsp;";

                UbezpWypTak.EditValue = ubwp ? "X" : "&nbsp;";
                UbezpWypNie.EditValue = !ubwp ? "X" : "&nbsp;";
            }

            string KodLiterowy(WypElement e, bool procent) {
                WypElementNieobecność en = e as WypElementNieobecność;
                string kod = "";
                if (en != null && en.Nieobecność != null) {
                    if (en.Nieobecność.Zwolnienie.KodChoroby != "")
                        kod = en.Nieobecność.Zwolnienie.KodChoroby;
                    if (procent && e.SkładnikGłówny != null &&
                        (en.Nieobecność.Definicja.Przyczyna == PrzyczynaNieobecnosci.UrlopMacierzyński || en.Nieobecność.Definicja.Przyczyna == PrzyczynaNieobecnosci.UrlopRodzicielski))
                        kod += (kod != "" ? "/" : "") + e.SkładnikGłówny.Procent;
                }
                return kod;
            }

            string GetElementyInfo(ICollection<WypElement> elementy, bool procent) {
                if (elementy.Count == 0)
                    return "";

                Dictionary<FromTo, string> okresy = new Dictionary<FromTo, string>();
                Dictionary<FromTo, int> hash = new Dictionary<FromTo, int>();
                int storno, ilosc;
                string kod;

                foreach (WypElement e in elementy) {
                    storno = (e is WypElementStorno || e.Dni < 0) ? -1 : 1;
                    if (hash.TryGetValue(e.Okres, out ilosc))
                        hash[e.Okres] = ilosc + storno;
                    else
                        hash.Add(e.Okres, storno);
                    if (!okresy.TryGetValue(e.Okres, out kod))
                        okresy.Add(e.Okres, KodLiterowy(e, procent));
                    else if (kod == "")
                        okresy[e.Okres] = KodLiterowy(e, procent);
                }

                string result = "";
                foreach (FromTo ft in okresy.Keys) {
                    if (hash[ft] <= 0)
                        continue;
                    kod = okresy[ft];
                    if (kod == "")
                        kod = ".....";
                    string line = string.Format("{0} - {1} {2}", ft.From, ft.To, kod);
                    result += (result != "" ? "<br/>" : "") + line;
                }

                return result;
            }

            void LiczWynagrodzeniaZasiłki(Pracownik pracownik) {
                List<WypElement> wynagrodzania = new List<WypElement>();
                List<WypElement> zasiłki = new List<WypElement>();
                List<WypElement> macieżyńskie = new List<WypElement>();

                bool macieżyński = false, chorobowy = false, rehabilitacyjny = false;

                Dictionary<FromTo, string> okresy2 = new Dictionary<FromTo, string>();
                Dictionary<FromTo, int> hash = new Dictionary<FromTo, int>();
                int storno, ilosc;
                string def;

                SubTable st = PlaceModule.GetInstance(dc).WypElementy.WgPracownik[pracownik];
                st = new SubTable(st, pars.OkresZatrudnienia());
                foreach (WypElement e in st) {
                    try {
                        if (e is WypElementStorno || e.Dni < 0) {
                            if (hash.TryGetValue(e.Okres, out ilosc))
                                hash[e.Okres] = ilosc - 1;
                            else
                                hash.Add(e.Okres, -1);
                        }
                        KodRSA kod = e.KodRSA;
                        if (kod != null && kod.WynagrodzenieChorobowe) {
                            if (pars.OkresZatrudnieniaRok().IsIntersected(e.Okres))
                                wynagrodzania.Add(e);
                        }
                        else if (e.ZasiłekZus /*&& e.Wartosc != 0*/ && pars.OkresZasiłkowy.IsIntersected(e.Okres)) {
                            if (e.Wartosc != 0) zasiłki.Add(e);
                            WypElementNieobecność en = e as WypElementNieobecność;
                            Nieobecnosc ni = en == null ? null : en.Nieobecność;
                            if (ni != null)
                                switch (ni.Definicja.Przyczyna) {
                                    case PrzyczynaNieobecnosci.UrlopRodzicielski:
                                    case PrzyczynaNieobecnosci.UrlopMacierzyński:
                                    case PrzyczynaNieobecnosci.UrlopOjcowski:
                                        storno = (e is WypElementStorno || e.Dni < 0) ? -1 : 1;
                                        if (hash.TryGetValue(e.Okres, out ilosc))
                                            hash[e.Okres] = ilosc + storno;
                                        else
                                            hash.Add(e.Okres, storno);
                                        if (ni.Definicja.Guid == new Guid("00000000-0006-0005-0040-000000000000") ||
                                            ni.Definicja.Guid == new Guid("00000000-0006-0005-0044-000000000000") ||
                                            ni.Definicja.Guid == new Guid("00000000-0006-0005-0045-000000000000")) {
                                            if (!okresy2.TryGetValue(e.Okres, out def))
                                                okresy2.Add(e.Okres, ni.Definicja.Nazwa);
                                            else
                                                okresy2[e.Okres] = ni.Definicja.Nazwa;
                                        }
                                        else {
                                            //if (!okresy.TryGetValue(e.Okres, out def))
                                            //    okresy.Add(e.Okres, ni.Definicja.Nazwa);
                                            //else
                                            //    okresy[e.Okres] = ni.Definicja.Nazwa;
                                            macieżyńskie.Add(e);
                                            zasiłki.Remove(e);
                                            macieżyński = true;
                                        }
                                        break;
                                    case PrzyczynaNieobecnosci.ZwolnienieChorobowe:
                                        chorobowy = true; break;
                                    case PrzyczynaNieobecnosci.UrlopRehabilitacyjny:
                                        rehabilitacyjny = true; break;
                                }
                        }
                    }
                    catch { Msg(); }
                }

                if (!macieżyński && !chorobowy && !rehabilitacyjny)
                    macieżyński = chorobowy = rehabilitacyjny = true;

                string urlopW = "";
                List<FromTo> lw = new List<FromTo>(okresy2.Keys);
                lw.Sort();
                foreach (FromTo ft in lw)
                    if (hash[ft] > 0)
                        urlopW += (urlopW != "" ? "<br/>" : "") + string.Format("{0} - {1}", ft.From, ft.To/*, okresy2[ft]*/);
                
                UrlopWychowawczyTak.EditValue = UrlopWychowawczyNie.EditValue = "&nbsp;";
                //UrlopWychowawczyTak.EditValue = urlopW != "" ? "X" : "&nbsp;";
                //UrlopWychowawczyNie.EditValue = urlopW == "" ? "X" : "&nbsp;";
                UrlopWychowawczy.EditValue = urlopW != "" ? urlopW : "<br/><br/>";

                /// string txt = "Płatnik składek wypłacił: " +
                ///    Striked("zasiłek chorobowy", chorobowy) + " / " +
                ///    Striked("zasiłek macierzyński", macieżyński) + " / " +
                ///    Striked("świadczenie rehabilitacyjne", rehabilitacyjny);
                /// ZASILKI_TEKST.EditValue = txt;
                /// 

                string wynagr = GetElementyInfo(wynagrodzania, false);
                WynagrodzeniaTak.EditValue = wynagr != "" ? "X" : "&nbsp;";
                WynagrodzeniaNie.EditValue = wynagr == "" ? "X" : "&nbsp;";
                Wynagrodzenia.EditValue = wynagr;

                string zas = GetElementyInfo(zasiłki, true);
                ZasilkiTak.EditValue = zas != "" ? "X" : "&nbsp;";
                ZasilkiNie.EditValue = zas == "" ? "X" : "&nbsp;";
                Zasilki.EditValue = zas;

                string mac = GetElementyInfo(macieżyńskie, true);
                MaciezynskieTak.EditValue = mac != "" ? "X" : "&nbsp;";
                MaciezynskieNie.EditValue = mac == "" ? "X" : "&nbsp;";
                Maciezynskie.EditValue = mac;
            }

            static string Striked(string text, bool ok) {
                if (ok)
                    return text;
                return string.Format("<font size=\"2\" style=\"text-decoration: line-through\">{0}</font>", text);
            }

            void LiczUbezpieczonych(ISessionable session) {
                Date data = pars.Ubezpieczeni;
                KadryModule kadry = KadryModule.GetInstance(session);

                foreach (Pracownik pracownik in kadry.Pracownicy) { }

                Set<Pracownik> pracownicy = new Set<Pracownik>();

                Soneta.Business.View historie = kadry.PracHistorie.WgPracownik.CreateView();
                historie.Condition &= RowCondition.Contains("Aktualnosc", data);
                historie.Condition &= RowCondition.Contains("Etat.Ubezpieczenia.Chorobowe.Okres", data);
                historie.Condition &= RowCondition.Contains("Etat.Okres", data);
                foreach (PracHistoria ph in historie)
                    pracownicy.Add(ph.Pracownik);

                Soneta.Business.View umowy = kadry.Umowy.WgPracownik.CreateView();
                umowy.Condition &= RowCondition.Contains("Ubezpieczenia.Chorobowe.Okres", data);
                umowy.Condition &= RowCondition.Contains("Okres", data);
                foreach (Umowa umowa in umowy)
                    pracownicy.Add(umowa.Pracownik);

                int ilosc = pracownicy.Count;
                foreach (Pracownik pracownik in pracownicy)
                    foreach (INieobecnosc n in pracownik.Nieobecnosci.GetIntersectedRows(FromTo.Day(data))) {
                        switch (n.Definicja.Przyczyna) {
                            case PrzyczynaNieobecnosci.UrlopWychowawczy:
                            case PrzyczynaNieobecnosci.UrlopWychowawczyZUS:
                            case PrzyczynaNieobecnosci.UrlopBezpłatny:
                                ilosc--;
                                break;
                        }
                        break;
                    }

                UbezpieczeniDo20.EditValue = ilosc <= 20 ? "X" : "&nbsp;";
                UbezpieczeniOd21.EditValue = ilosc > 20 ? "X" : "&nbsp;";
            }

            static string PrzyczynyNieobecności(Pracownik pracownik, FromTo okres) {
                Set<string> przyczyny = new Set<string>();
                try {
                    foreach (WypElement e in pracownik.Elementy[okres])
                        switch (GetZasilkiTyp(e)) {
                            case TypPodstawyZasilku.WliczaćDla:
                            case TypPodstawyZasilku.DopełniaćWedługGodzinDla:
                            case TypPodstawyZasilku.DopełniaćWedługDniDla:
                            case TypPodstawyZasilku.DopełniaćJakZasadniczeDla:
                            case TypPodstawyZasilku.WliczaćWNominalnejWysokościDla:
                                break;
                            default:
                                WypElementNieobecność en = e as WypElementNieobecność;
                                if (en != null && en.Nieobecność!=null)
                                    przyczyny.Add(en.Nieobecność.KategoriaZUS);
                                break;
                        }
                }
                catch { Msg(); }

                string result = "";
                foreach (string s in przyczyny)
                    result += (result == "" ? "" : ";") + s;
                return result;
            }

            string StripHTML(string HTMLText) {
                var reg = new Regex("<[^>]+>", RegexOptions.IgnoreCase);
                return reg.Replace(HTMLText, "");
            }

            void SetHeader() {
                IPieczątkaFirmy pf = ReportHeader.GetPieczątka(dc);
                dlFirma.EditValue = string.Format("<strong>{0}</strong>", pf.NazwaFormatowana);
                dlAdres1.EditValue = pf.Adres.Linia1;
                dlAdres2.EditValue = pf.Adres.Linia2;
                dlNIP.EditValue = string.Format("NIP: {0}", pf.NIP);
                BusinessModule bm = BusinessModule.GetInstance(dc.Session);
                ReportsLeaf rf = bm.Config.Reports.Defaults;
                string strip = StripHTML(rf.Postscript);
                dlDodatkowe.EditValue = "<font size='1pt'>" + strip + "</font><br/>";
                dlDodatkowe.Visible = !string.IsNullOrEmpty(strip);
            }

            void OnContextLoad(Object sender, EventArgs args) {
                SetHeader();
                report = dlTitle;

                dc.LeftMargin = dc.TopMargin = dc.RightMargin = dc.BottomMargin = 19;
                nieWliczaneDoPodstawy.Clear();

                Nieobecnosc nieobecnosc = pars.Nieobecność;
                if (nieobecnosc.Definicja.Typ!=TypNieobecnosci.NieobecnośćZUS)
                    throw new RowException(nieobecnosc, "Zaświadczenie może być drukowane tylko dla nieobecności ZUS.");
                PracHistoria ph = nieobecnosc.PracHistoria;
                Pracownik pracownik = nieobecnosc.Pracownik;

                LiczDaneFirmy(ph);
                LiczDanePracownika(ph);
                LiczOkresyUbezpieczenia(nieobecnosc, ph);
                LiczWynagrodzeniaZasiłki(pracownik);
                LiczUbezpieczonych(ph);
                NrRachunku.EditValue = pracownik.DomyslnyRachunek != null ? pracownik.DomyslnyRachunek.ToString() : "&nbsp;";

                if (nieobecnosc is Nieobecnosc && nieobecnosc.Zwolnienie.ZwolnienieDostarczone != Date.Empty) {
                    ZasLekTak.EditValue = "X";
                    ZasLekNie.EditValue = "&nbsp;";
                    ZasLekData.EditValue = nieobecnosc.Zwolnienie.ZwolnienieDostarczone.ToString();
                }
                else {
                    ZasLekTak.EditValue = "&nbsp;";
                    ZasLekNie.EditValue = "X";
                    ZasLekData.EditValue = "&nbsp;";
                }

                ZasDokTak.EditValue = ZasDokNie.EditValue = "&nbsp;";
                if (nieobecnosc is Nieobecnosc && nieobecnosc.Zwolnienie.Numer != "") {
                    //ZasDokTak.EditValue = "X";
                    //ZasDokNie.EditValue = "&nbsp;";
                    ZasDokNumer.EditValue = nieobecnosc.Zwolnienie.Numer;
                }
                else {
                    //ZasDokTak.EditValue = "&nbsp;";
                    //ZasDokNie.EditValue = "X";
                    ZasDokNumer.EditValue = "&nbsp;";
                }

                //Miesięczne
                ArrayList miesiąc = new ArrayList();
                try {
                    foreach (WypElement e in pracownik.Elementy[pars.Okres])
                        if (RodzajOkresu(e.Okres)==1)
                            miesiąc.Add(e);
                }
                catch { Msg(); }

                Grid2.DataSource = LiczMiesiące(pracownik, miesiąc);

                if (nieWliczaneDoPodstawy.Count > 0) {
                    List<string> lst = new List<string>(nieWliczaneDoPodstawy.Keys);
                    lst.Sort();
                    string ss = "";
                    foreach (string s in lst)
                        if (ss == "")
                            ss = s;
                        else
                            ss = ", " + s;
                    dlUwagi.EditValue = string.Format("Zostały wykazane składniki wynagrodzenia, do których pracownik zachowuje prawo za okres pobierania zasiłku ({0}).", ss).ToUpper();
                }
                else
                    dlUwagi.EditValue = "<br /><br /><br /><br />";
            }

            ArrayList Clear(ArrayList lista) {
                ArrayList result = new ArrayList();
                foreach (SumOkresowy okr in lista)
                    if (okr.Kwota != 0)
                        result.Add(okr);
                return result;
            }

            public static void Msg(object obj) {
            }

            public static DataLabel report;

            public static void Msg() {
                string msg = "Wydruk przygotowany na podstawie danych, do których operator ma prawa dostępu";
                if (!report.EditValue.ToString().Contains(msg))
                    report.EditValue = msg;
            }

</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body style="font-family: Tahoma">
		<form id="DeklaracjaZ3" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Kalend.Nieobecnosc,Soneta.KadryPlace"></ea:datacontext>

            <ea:SectionMarker ID="SectionMarker9" runat="server"></ea:SectionMarker>
		    <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False" 
			    ResetPageCounter="True"></ea:PageBreak>
            <ea:Section runat="server" SectionType="Header"></ea:Section>
            <ea:Section runat="server" SectionType="Body">

            <p align="right">
                <b>ZUS Z-3a</b>
            </p>

            <table cellSpacing="0" width="100%" style="border-width: 0px 0px 0px 0px; border-style: solid; border-color: silver; font-family: tahoma; text-align:left;">
			    <tr>
            		<td width="35%" valign="top" align="left" style="border-width: 0px 0px 0px 0px; border-style: solid; border-color: silver; font-size: 9pt;">
				        <ea:datalabel id="dlFirma" runat="server" Bold="false"></ea:datalabel><br /> 
				        <ea:datalabel id="dlAdres1" runat="server" Bold="false"></ea:datalabel><br /> 
				        <ea:datalabel id="dlAdres2" runat="server" Bold="false"></ea:datalabel><br /> 
				        <ea:datalabel id="dlNIP" runat="server" Bold="false"></ea:datalabel><br /> 
				        <ea:datalabel id="dlDodatkowe" runat="server" Bold="false"></ea:datalabel>
                        ....................................................................<br />
                        Pieczątka płatnika składek, jeśli ją posiadasz<br /> 
                    </td>
                </tr>
            </table>
            <br />

            <p align="center">
                <b>ZAŚWIADCZENIE PŁATNIKA SKŁADEK</b><br />
                <ea:datalabel id="dlTitle" runat="server" Bold="false"></ea:datalabel>
            </p>

            <font face="Tahoma" size="2">
                <p style="text-align:left">
                    <u><b>Instrukcja wypełniania</b></u><br />
                </p>
                Wypełnij to zaświadczenie i przekaż je do nas, jeśli osobie niebędącej pracownikiem mamy ustalić prawo do zasiłku
                chorobowego, zasiłku opiekuńczego, zasiłku macierzyńskiego lub świadczenia rehabilitacyjnego.<br />
                <ol>
                    <li>Wypełnij WIELKIMI LITERAMI</li>
                    <li>Pola wyboru zaznacz znakiem <b>X</b></li>
                    <li>Wypełnij kolorem czarnym lub niebieskim (nie ołówkiem)</li>
                    <li>Zanim wypełnisz zaświadczenie, zapoznaj się z <b>Pouczeniem</b></li>
                </ol>
            </font>

            <font face="Tahoma" size="2">
                <u><b>Dane płatnika składek</b></u><br/>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">

					<TR>
						<TD width="35%" align="right"><FONT size="2">NIP</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaNIP" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Numer REGON</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaREGON" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Jeśli nie podałeś NIP, podaj REGON</i></FONT>
                        </TD>
                    </TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Numer PESEL</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaPESEL" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Jeśli nie masz nadanego NIP i REGON, podaj PESEL</i></FONT>
                        </TD>
                    </TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Rodzaj, seria i numer dokumentu<br />potwierdzającego tożsamość</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel id="FirmaRodzaj" runat="server"></ea:DataLabel>&nbsp;
							<ea:DataLabel id="FirmaDokument" runat="server"></ea:DataLabel></FONT>
                        </TD>
                    </TR>
					<TR>
						<TD width="35%" align="right">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Jeśli nie masz nadanego NIP, REGON i PESEL, podaj serię i numer dokumentu potwierdzającego tożsamość</i></FONT>
                        </TD>
                    </TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Nazwa albo imię i nazwisko</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaNazwa" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Ulica</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaUlica" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%" align="right"><FONT size="2">Numer domu</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaNrDomu" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
						<TD width="20%" align="right"><FONT size="2">Numer lokalu</FONT></TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaNrLokalu" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Kod pocztowy</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaKodP" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
						<TD width="20%" align="right"><FONT size="2">Miejscowość</FONT></TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
						    <FONT size="2"><ea:DataLabel ID="FirmaMiejscowosc" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%" align="right"><FONT size="2">Nazwa państwa</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaKraj" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Podaj, jeśli Twój adres jest inny niż polski</i></FONT>
						</TD>
					</TR>
                </TABLE>
            </font>

            <font face="Tahoma" size="2">
                <u><b>Dane osoby ubezpieczonej</b></u><br/>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%" align="right"><FONT size="2">Numer PESEL</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel DataMember="PracHistoria.PESEL" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Rodzaj, seria i numer dokumentu<br />potwierdzającego tożsamość</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel id="DOKRODZAJ" runat="server"></ea:DataLabel>&nbsp;
							<ea:DataLabel id="DOKUBEZP" runat="server"></ea:DataLabel></FONT>
                        </TD>
                    </TR>
					<TR>
						<TD width="35%" align="right">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Jeśli nie ma nadanego PESEL, podaj serię i numer dokumentu potwierdzającego tożsamość</i></FONT>
                        </TD>
                    </TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Imię</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="PracImie" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Nazwisko</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="PracNazwisko" runat="server"></ea:DataLabel></FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Ulica</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="AdresUlica" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%" align="right"><FONT size="2">Numer domu</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="AdresNrDomu" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
						<TD width="20%" align="right"><FONT size="2">Numer lokalu</FONT></TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="AdresNrLokalu" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Kod pocztowy</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="AdresKodPocztowyS" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
						<TD width="20%" align="right"><FONT size="2">Miejscowość</FONT></TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
						    <FONT size="2"><ea:DataLabel ID="AdresMiejscowosc" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%" align="right"><FONT size="2">Nazwa państwa</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="AdresKraj" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Podaj, jeśli Twój adres jest inny niż polski</i></FONT>
						</TD>
					</TR>
                </TABLE>
            </font>
            <br />

			<ea:PageBreak id="PageBreak2" runat="server" Required="False"></ea:PageBreak>

            <font face="Tahoma" size="2">
            <u><b>Ubezpieczony występuje o:</b></u><br/>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="22%">
                            <FONT size="2">[ ] zasiłek chorobowy</FONT>
						</TD>
						<TD width="1%">&nbsp;</TD>
						<TD width="22%">
                            <FONT size="2">[ ] zasiłek opiekuńczy</FONT>
						</TD>
						<TD width="1%">&nbsp;</TD>
						<TD width="22%">
                            <FONT size="2">[ ] zasiłek macierzyński</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="30%">
                            <FONT size="2">[ ] świadczenie rehabilitacyjne</FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
                        <TD width="15%">
                            <FONT size="2">Za okres:</FONT>
                        </TD>
						<TD width="50%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><br /><br /></FONT>
						</TD>
                        <TD width="5%">&nbsp;</TD>
						<TD width="30%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><br /><br /></FONT>
						</TD>
                    </TR>
					<TR>
                        <TD width="15%"></TD>
                        <TD width="50%">
                            <FONT size="1"><i>Podaj okres od–do</i></FONT>
                        </TD>
                        <TD width="5%">&nbsp;</TD>
                        <TD width="30%">
                            <FONT size="1"><i>Podaj datę złożenia wniosku o zasiłek macierzyński (dd/mm/rrrr)</i></FONT>
                        </TD>
                    </TR>
                </TABLE>
            </font>

            <font face="Tahoma" size="2">
            <u><b>Informacje o zaświadczeniach lekarskich</b></u><br/>
                <font face="Tahoma" size="1">
                    <i>Wypełnij, gdy pracownik wystąpił o zasiłek chorobowy lub zasiłek opiekuńczy z powodu opieki nad chorym dzieckiem lub innym chorym członkiem rodziny</i>
                </font>
                <br /><br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="80%">
                            <FONT size="2">1. Czy załączasz zaświadczenie lekarskie</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">
                            [<ea:DataLabel ID="ZasLekTak" runat="server"></ea:DataLabel>] TAK</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">
                            [<ea:DataLabel ID="ZasLekNie" runat="server"></ea:DataLabel>] NIE</FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
                                <ea:DataLabel ID="ZasLekData" runat="server"></ea:DataLabel>
                                <br /><br />
                            </FONT>
						</TD>
                    </TR>
					<TR>
                        <TD width="100%">
                            <FONT size="1"><i>Jeśli <b>TAK</b>, podaj datę, kiedy wpłynęło do płatnika składek</i></FONT>
                        </TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="80%">
                            <FONT size="2">2. Czy zaświadczenie lekarskie zostało wystawione w formie elektronicznej (e-ZLA)</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">
                            [<ea:DataLabel ID="ZasDokTak" runat="server"></ea:DataLabel>] TAK</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">
                            [<ea:DataLabel ID="ZasDokNie" runat="server"></ea:DataLabel>] NIE</FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
                                <ea:DataLabel ID="ZasDokNumer" runat="server"></ea:DataLabel>
                                <br /><br />
                            </FONT>
						</TD>
                    </TR>
					<TR>
                        <TD width="100%">
                            <FONT size="1"><i>Jeśli <b>TAK</b>, podaj, jeśli znasz – serię i numer zaświadczenia lekarskiego</i></FONT>
                        </TD>
                    </TR>
                </TABLE>
            </font>
            <br />

            <font face="Tahoma" size="2">
            <u><b>Informacje o ubezpieczeniu</b></u><br/>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="79%">
                            <FONT size="2">Czy jest objęty ubezpieczeniem</FONT>
						</TD>
						<TD width="8%">
                            <FONT size="2"></FONT>
                        </TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="8%">
                            <FONT size="2"></FONT>
                        </TD>
                    </TR>
					<TR>
                        <TD>&nbsp;</TD>
                    </TR>
					<TR>
						<TD width="79%">
                            <FONT size="2">w razie choroby i macierzyństwa <i>(ubezpieczenie chorobowe)</i></FONT>
						</TD>
						<TD width="8%">
                            <FONT size="2">
                                [<ea:DataLabel id="UbezpChorTak" runat="server"></ea:DataLabel>] TAK
                            </FONT>
                        </TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="8%">
                            <FONT size="2">
                                [<ea:DataLabel id="UbezpChorNie" runat="server"></ea:DataLabel>] NIE
                            </FONT>
                        </TD>
                    </TR>
					<TR>
                        <TD>&nbsp;</TD>
                    </TR>
					<TR>
						<TD width="79%">
                            <FONT size="2">z tytułu wypadków przy pracy i chorób zawodowych <i>(ubezpieczenie wypadkowe)</i></FONT>
						</TD>
						<TD width="8%">
                            <FONT size="2">
                                [<ea:DataLabel id="UbezpWypTak" runat="server"></ea:DataLabel>] TAK
                            </FONT>
                        </TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="8%">
                            <FONT size="2">
                                [<ea:DataLabel id="UbezpWypNie" runat="server"></ea:DataLabel>] NIE
                            </FONT>
                        </TD>
                    </TR>
                </TABLE>
                <br />
                <OL>
                    <li>[  ] jako członek rolniczej spółdzielni produkcyjnej lub spółdzielni kółek rolniczych</li>
                    <br />
                    <li>[  ] jako osoba wykonująca pracę na podstawie umowy agencyjnej lub umowy zlecenia albo innej umowy o świadczeniu usług, do której zgodnie z kodeksem cywilnym, stosuje się przepisy dotyczące zlecenia, lub jako osoba współpracująca</li>
                    <br />
                    <li>[  ] jako osoba wykonująca umowę o pracę nakładczą</li>
                    <br />
                    <li>[  ] jako osoba wykonująca odpłatnie pracę na podstawie skierowania do pracy w czasie odbywania kary pozbawienia wolności albo tymczasowego aresztowania</li>
                    <br />
                    <li>[  ] jako poseł lub senator pobierający uposażenie</li>
                    <br />
                    <li>[  ] jako osoba pobierająca stypendium sportowe</li>
                    <br />
                    <li>[  ] jako słuchacz Krajowej Szkoły Administracji Publicznej pobierający stypendium</li>
                    <br />
                    <li>[  ] jako osoba pobierająca stypendium w okresie odbywania szkolenia, stażu lub przygotowania zawodowego dorosłych, na które została skierowana przez powiatowy urząd pracy lub inny podmiot kierujący, albo osoba pobierająca stypendium na podstawie przepisów o promocji zatrudnienia i instytucjach rynku pracy w okresie odbywania studiów podyplomowych</li>
                    <br />
                    <li>[  ] jako osoba odbywająca służbę zastępczą</li>
                    <br />
                    <li>[  ] jako funkcjonariusz Służby Celno-Skarbowej</li>
                    <br />
                    <li>[  ] jako osoba sprawująca opiekę nad dzieckiem na podstawie umowy uaktywniającej w rozumieniu ustawy z dnia 4 lutego 2011 r. o opiece nad dzieckiem do lat 3</li>
                </OL>
            </font>
            <br />

			<ea:PageBreak id="PageBreak5" runat="server" Required="False"></ea:PageBreak>

            <font face="Tahoma" size="2">
            <u><b>Informacje o ubezpieczonym</b></u><br/>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="45%">
                            <FONT size="2">1. Ubezpieczeniu chorobowemu podlega</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="55%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
					            <ea:DataLabel id="AKTUALNE_OKRESY_CHR" runat="server"></ea:DataLabel>
                                <br /><br />
                            </FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="45%"></TD>
						<TD width="5%"></TD>
						<TD width="55%">
                            <FONT size="1"><i>Podaj datę, od kiedy podlega lub okres podlegania od–do</i></FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="45%">
                            <FONT size="2">2. Ubezpieczeniu wypadkowemu podlega</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="55%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
              					<ea:DataLabel id="AKTUALNE_OKRESY_WYP" runat="server"></ea:DataLabel>
                                <br /><br />
                            </FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="45%"></TD>
						<TD width="5%"></TD>
						<TD width="55%">
                            <FONT size="1"><i>Podaj datę, od kiedy podlega lub okres podlegania od–do</i></FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%">
                            <FONT size="2">3. Czy tytuł ubezpieczenia ustał</FONT>
						</TD>
						<TD width="10%">
                            <FONT size="2">
                                [<ea:DataLabel id="AKTUALNE_OKRESY_CHR_UBEZP_TAK" runat="server"></ea:DataLabel>] TAK
                            </FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="15%">
                            <FONT size="2">
                                [<ea:DataLabel id="AKTUALNE_OKRESY_CHR_UBEZP_NIE" runat="server"></ea:DataLabel>] NIE
                            </FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="25%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
              					<ea:DataLabel id="AKTUALNE_OKRESY_CHR_TYTUL" runat="server"></ea:DataLabel>
                                <br /><br />
                            </FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="35%"></TD>
						<TD width="10%"></TD>
						<TD width="5%"></TD>
						<TD width="15%"></TD>
						<TD width="5%"></TD>
						<TD width="25%">
                            <FONT size="1"><i>Jeśli <b>TAK</b>, podaj datę ustania</i></FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%">
                            <FONT size="2">4. Czy niezdolność do pracy powstała z powodu</FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="25%">
                            <FONT size="2">[ ] choroby zawodowej</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="25%">
                            <FONT size="2">[ ] wypadku przy pracy</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="40%">
                            <FONT size="2">[ ] wypadku w drodze do pracy lub z pracy</FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="10%">
                            <FONT size="2">[ ] TAK</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="10%">
                            <FONT size="2">[ ] NIE</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="70%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><br /><br /></FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="10%"></TD>
						<TD width="5%"></TD>
						<TD width="10%"></TD>
						<TD width="5%"></TD>
						<TD width="70%">
                            <FONT size="1"><i>Jeśli <b>TAK</b>, podaj dokument potwierdzający (decyzja/ protokół karta wypadku), numer oraz datę jego sporządzenia</i></FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%">
                            <FONT size="2">5. Czy w okresie niezdolności do pracy z powodu choroby, sprawowania opieki lub macierzyństwa</FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="45%">
                            <FONT size="2">[ ] korzysta z urlopu bezpłatnego</FONT>
						</TD>
						<TD width="10%">&nbsp;</TD>
						<TD width="45%">
                            <FONT size="2">[ ] przebywa w areszcie tymczasowym</FONT>
						</TD>
                    </TR>
                    <TR>
						<TD width="45%">&nbsp;</TD>
						<TD width="10%">&nbsp;</TD>
						<TD width="45%">&nbsp;</TD>
                    </TR>
					<TR>
						<TD width="45%">
                            <FONT size="2">[ ] korzysta z urlopu wychowawczego</FONT>
						</TD>
						<TD width="10%">&nbsp;</TD>
						<TD width="45%">
                            <FONT size="2">[ ] odbywa karę pozbawienia wolności</FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="10%"><FONT size="2">
                                [<ea:DataLabel ID="UrlopWychowawczyTak" runat="server"></ea:DataLabel>] TAK</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="10%"><FONT size="2">
                                [<ea:DataLabel ID="UrlopWychowawczyNie" runat="server"></ea:DataLabel>] NIE</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="70%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
                                <ea:DataLabel ID="UrlopWychowawczy" runat="server"></ea:DataLabel>
                                <br /><br />
                            </FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="10%"></TD>
						<TD width="5%"></TD>
						<TD width="10%"></TD>
						<TD width="5%"></TD>
						<TD width="70%">
                            <FONT size="1"><i>Jeśli <b>TAK</b>, podaj okresy od–do</i></FONT>
						</TD>
                    </TR>
                </TABLE>
            </font>
            <br />

            <font face="Tahoma" size="2">
            <u><b>Informacje o wypłaconych świadczeniach</b></u><br/>
            <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="80%">
                            <FONT size="2">1. Czy wypłaciłeś wynagrodzenie za okresy orzeczonej niezdolności do pracy w danym roku kalendarzowym na podstawie art. 92 Kodeksu pracy <i>(dotyczy osoby wykonującej pracę nakładczą oraz osoby odbywającej służbę zastępczą)</i></FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">
                                [<ea:DataLabel ID="WynagrodzeniaTak" runat="server"></ea:DataLabel>] TAK</FONT>
                        </TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">
                                [<ea:DataLabel ID="WynagrodzeniaNie" runat="server"></ea:DataLabel>] NIE</FONT>
                        </TD>
                    </TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
						        <ea:DataLabel id="Wynagrodzenia" runat="server"></ea:DataLabel>
                                <br /><br />
                            </FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="100%">
                            <FONT size="1"><i>Jeśli <b>TAK</b>, podaj okresy od–do oraz kod literowy. Podaj także okresy wynagrodzenia wypłaconego w poprzednim roku, wliczane do jednego okresu zasiłkowego</i></FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="80%">
                            <FONT size="2">2. Czy wypłaciłeś zasiłek chorobowy / świadczenie rehabilitacyjne</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">
                            [<ea:DataLabel ID="ZasilkiTak" runat="server"></ea:DataLabel>] TAK</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">
                            [<ea:DataLabel ID="ZasilkiNie" runat="server"></ea:DataLabel>] NIE</FONT>
						</TD>
                    </TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
                                <ea:DataLabel ID="Zasilki" runat="server"></ea:DataLabel>
                                <br /><br />
                            </FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="100%">
                            <FONT size="1"><i>Jeśli <b>TAK</b>, podaj okresy od–do oraz kod literowy. Podaj okresy wliczone do jednego okresu zasiłkowego</i></FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="80%">
                            <FONT size="2">3. Czy wypłaciłeś zasiłek macierzyński</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">
                            [<ea:DataLabel ID="MaciezynskieTak" runat="server"></ea:DataLabel>] TAK</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">
                            [<ea:DataLabel ID="MaciezynskieNie" runat="server"></ea:DataLabel>] NIE</FONT>
						</TD>
                    </TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
                                <ea:DataLabel ID="Maciezynskie" runat="server"></ea:DataLabel>
                                <br /><br />
                            </FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="100%">
                            <FONT size="1"><i>Jeśli <b>TAK</b>, podaj okresy od–do oraz stawkę % zasiłku macierzyńskiego</i></FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="80%">
                            <FONT size="2">Czy wypłaciłeś uposażenie/ stypendium/ inne świadczenie za okresy orzeczonej niezdolności do pracy <i>(dotyczy tylko osób, o których mowa w pkt. 5–8 sekcji Informacje o ubezpieczeniu)</i></FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">[ ] TAK</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">[ ] NIE</FONT>
						</TD>
                    </TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
                                <br /><br />
                            </FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="100%">
                            <FONT size="1"><i>Jeśli <b>TAK</b>, podaj okresy od–do oraz kod literowy. Podaj okresy wliczone do jednego okresu zasiłkowego</i></FONT>
						</TD>
                    </TR>
                </TABLE>
            </font>

			<ea:PageBreak id="PageBreak3" runat="server" Required="False"></ea:PageBreak>

            <font face="Tahoma" size="2">
            <u><b>Pozostałe informacje</b></u><br/>
            <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="43%">
                            <FONT size="2">Czy zgłosiłeś do ubezpieczenia chorobowego</FONT>
						</TD>
						<TD width="1%">&nbsp;</TD>
						<TD width="25%"><FONT size="2">
                            [<ea:DataLabel ID="UbezpieczeniDo20" runat="server"></ea:DataLabel>] do 20 ubezpieczonych</FONT>
						</TD>
						<TD width="1%">&nbsp;</TD>
						<TD width="30%"><FONT size="2">
                            [<ea:DataLabel ID="UbezpieczeniOd21" runat="server"></ea:DataLabel>] powyżej 20 ubezpieczonych</FONT>
						</TD>
                    </TR>
                </TABLE>
            </font>
            <br />

			<ea:PageBreak id="PageBreak4" runat="server" Required="False"></ea:PageBreak>

            <font face="Tahoma" size="2">
            <u><b>Informacje o przychodzie</b></u><br/>
            <br />
                Przychód stanowiący podstawę wymiaru składek
                <ea:grid id="Grid2" runat="server">
				    <Columns>
					    <ea:GridColumn Width="10" Align="Center" DataMember="Miesiąc.Year" Caption="Rok" runat="server"></ea:GridColumn>
					    <ea:GridColumn Width="11" Align="Center" DataMember="Miesiąc.Month" Caption="Miesiąc" runat="server"></ea:GridColumn>
					    <ea:GridColumn Width="20" Align="Center" DataMember="Praca" Caption="Liczba dni, kt&#243;re ubezpieczony:~przepracował"
						    Format="{0:00}" runat="server"></ea:GridColumn>
					    <ea:GridColumn Width="20" Align="Center" DataMember="Norma" Caption="Liczba dni, kt&#243;re ubezpieczony:~był obowiązany przepracować" runat="server"></ea:GridColumn>
					    <ea:GridColumn Width="34" Align="Right" DataMember="Faktyczne" Caption="Podstawa wymiaru składek"
						    Format="{0:n}" runat="server"></ea:GridColumn>
				    </Columns>
			    </ea:grid>
            </font>
            <br />

			<ea:PageBreak id="PageBreak9" runat="server" Required="False"></ea:PageBreak>

            <font face="Tahoma" size="2">
            <u><b>Uwagi:</b></u><br/>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
                                <ea:DataLabel id="dlUwagi" runat="server" Bold="False"></ea:DataLabel>
                                <br /><br />
                            </FONT>
						</TD>
                    </TR>
                </TABLE>
            </font>
            <br />

			<ea:PageBreak id="PageBreak10" runat="server" Required="False"></ea:PageBreak>

            <font face="Tahoma" size="2">
            <u><b>Rachunek bankowy</b></u><br/>
                <font face="Tahoma" size="1">
                    <i>Podaj rachunek bankowy ubezpieczonego</i>
                </font>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%">
					<TR>
						<TD width="100%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel id="NrRachunku" runat="server"></ea:DataLabel></FONT>
                        </TD>
                    </TR>
				</TABLE>
            </font>
            <br />

			<ea:PageBreak id="PageBreak11" runat="server" Required="False"></ea:PageBreak>

            <font face="Tahoma" size="2">
                <b>Oświadczam, że dane zawarte w zaświadczeniu podałem zgodnie z prawdą.
                    Jeżeli ulegną one zmianie, zobowiązuję się poinformować o nich ZUS.</b><br/>
            </font>
            <br />

			<cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="False">
				<Subtitles>
					<cc1:FooterSubtitle Caption="Data: dd/mm/rrrr" Width="50"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Podpis upoważnionego pracownika, nr telefonu oraz pieczątka zawierająca imię, nazwisko i stanowisko" Width="50"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:reportfooter>

			<ea:PageBreak id="PageBreak12" runat="server" Required="True"></ea:PageBreak>

            <p align="right">
                <b>ZUS Z-3a</b>
            </p>
			<P style="text-align: center"><FONT size="2"><strong>POUCZENIE</strong></FONT></P>
            <p style="text-align: justify">
                <font size="2">
                    <b>Podstawa prawna: ustawa z dnia 25 czerwca 1999 r. o świadczeniach pieniężnych z ubezpieczenia społecznego w razie choroby i macierzyństwa,
                    ustawa z dnia 30 października 2002 r. o ubezpieczeniu społecznym z tytułu wypadków przy pracy i chorób zawodowych oraz rozporządzenie Ministra
                    Rodziny, Pracy i Polityki Społecznej z 8 grudnia 2015 r. w sprawie zakresu informacji o okolicznościach mających wpływ na prawo do zasiłków
                    z ubezpieczenia społecznego w razie choroby i macierzyństwa lub ich wysokość oraz dokumentów niezbędnych do przyznania i wypłaty zasiłków.</b>
                </font>
                <br /><br />
                <font size="3">
                    <b><i>Sekcja: Informacje o zaświadczeniach lekarskich</i></b>
                </font>
                <br /><br />
                <font size="2">
                    <b>Do pkt. 1</b>
                    <br />
                    Załącz zaświadczenie lekarskie, jeśli zostało wystawione ubezpieczonemu na druku ZUS ZLA, na zasadach obowiązujących do 31 grudnia 2015 r.<br />
                    Ubezpieczony powinien dostarczyć zaświadczenie lekarskie na druku ZUS ZLA do płatnika składek w ciągu 7 dni od jego wystawienia.
                    Jeżeli ten termin zostanie przekroczony, zasiłek chorobowy jest obniżany o 25%, od 8 dnia orzeczonej niezdolności do pracy do dnia dostarczenia zaświadczenia lekarskiego.<br />
                    W przypadku kolejnego zaświadczenia lekarskiego wystawionego na druku ZUS ZLA za okres dalszej, nieprzerwanej niezdolności do pracy nie przesyłaj ponownie zaświadczenia
                    płatnika składek Z-3a, podaj jednak datę dostarczenia przez ubezpieczonego zaświadczenia lekarskiego ZUS ZLA oraz, czy tytuł ubezpieczenia, jak również ubezpieczenie chorobowe
                    lub wypadkowe trwa nadal. Informacje te poświadcz pieczątką i podpisem.
                    <br /><br />
                    <b>Do pkt. 2</b>
                    <br />
                    Jeśli zaświadczenie lekarskie zostało wystawione ubezpieczonemu w formie elektronicznej (e-ZLA), podaj tylko jego serię oraz numer (jeżeli je znasz).
                    Jeśli zaświadczenie lekarskie zostało wystawione ubezpieczonemu elektronicznie, nie obowiązują terminy na jego dostarczenie.<br />
                    W przypadku kolejnego zaświadczenia lekarskiego wystawionego elektronicznie za okres nieprzerwanej niezdolności do pracy, prześlij do ZUS zaświadczenie
                    płatnika składek Z-3a, wypełnione do pkt. 3 sekcji Informacje o ubezpieczonym włącznie.
                </font>
                <br /><br />
                <font size="3">
                    <b><i>Sekcja: Informacje o ubezpieczeniu</i></b>
                </font>
                <br /><br />
                <font size="2">
                    Zaznacz odpowiedni tytuł ubezpieczenia chorobowego lub wypadkowego.<br />
                    Osoby, o których mowa w pkt. 1 i 9, nabywają prawo do zasiłku chorobowego z ubezpieczenia chorobowego po upływie 30 dni nieprzerwanego ubezpieczenia chorobowego, a osoby,
                    o których mowa w pkt. 2–4 i 11, po upływie 90 dni nieprzerwanego ubezpieczenia chorobowego.<br />
                    Do 30- i 90-dniowego okresu ubezpieczenia chorobowego wlicza się poprzednie okresy ubezpieczenia chorobowego, jeżeli przerwa między nimi nie przekroczyła 30 dni lub była spowodowana
                    urlopem bezpłatnym, urlopem wychowawczym albo odbywaniem czynnej służby wojskowej przez żołnierza niezawodowego. Warunek posiadania okresu ubezpieczenia chorobowego nie obowiązuje:<br />
                    - absolwentów szkół oraz szkół wyższych, którzy zostali objęci ubezpieczeniem chorobowym w ciągu 90 dni od dnia ukończenia szkoły lub uzyskania dyplomu ukończenia studiów wyższych,<br />
                    - osób, których niezdolność do pracy została spowodowana chorobą zawodową, wypadkiem przy pracy, wypadkiem w drodze do pracy lub z pracy,<br />
                    - ubezpieczonych obowiązkowo, którzy mają wcześniejszy co najmniej 10-letni okres obowiązkowego ubezpieczenia chorobowego, w tym również ubezpieczenia społecznego przed dniem 1 stycznia 1999 r.
                    (dotyczy to wyłącznie członków rolniczych spółdzielni produkcyjnych i spółdzielni kółek rolniczych oraz osób odbywających służbę zastępczą),<br />
                    - posłów i senatorów, którzy przystąpili do ubezpieczenia chorobowego w ciągu 90 dni od ukończenia kadencji.<br />
                    <b>Okoliczności wyłączające obowiązek posiadania 30- lub 90-dniowego okresu ubezpieczenia chorobowego ubezpieczony powinien udokumentować.</b>
                </font>
                <br /><br />
                <font size="3">
                    <b><i>Sekcja: Informacje o ubezpieczonym</i></b>
                </font>
                <br /><br />
                <font size="2">
                    <b>Do pkt. 1 i 2</b>
                    <br />
                    Wpisz datę początku i końca trwania ubezpieczenia (dzień, miesiąc, rok). W przypadku gdy ubezpieczenie trwa, wpisz tylko datę początkową.
                    <br /><br />
                    <b>Do pkt. 3</b>
                    <br />
                    Podaj czy tytuł ubezpieczenia ustał, czy trwa nadal; jeżeli ustał wpisz datę ustania tytułu ubezpieczenia.
                    <br /><br />
                    <b>Do pkt. 4</b>
                    <br />
                    Wypłaty świadczeń z tytułu wypadku przy pracy albo wypadku w drodze do pracy lub z pracy ZUS dokonuje po uprzednim uznaniu zdarzenia za taki wypadek, dlatego
                    do wniosku dołącz niezbędną dokumentację wypadkową. W przypadku choroby zawodowej dołącz decyzję o stwierdzeniu choroby zawodowej i zaświadczenie lekarza, które stwierdza,
                    że niezdolność do pracy ubezpieczonego jest spowodowana chorobą zawodową.
                </font>
                <br /><br />
                <font size="3">
                    <b><i>Sekcja: Informacje o wypłaconych świadczeniach</i></b>
                </font>
                <br /><br />
                <font size="2">
                    <b>Do pkt. 1</b>
                    <br />
                    Jeżeli w poprzednim roku kalendarzowym wypłaciłeś ubezpieczonemu wynagrodzenie chorobowe za okres wliczany do jednego okresu zasiłkowego,
                    podaj również okresy wypłaty wynagrodzenia w poprzednim roku.
                    <br /><br />
                    <b>Do pkt. 2</b>
                    <br />
                    Do jednego okresu zasiłkowego wlicza się wszystkie okresy nieprzerwanej niezdolności do pracy, oraz okresy przedzielone przerwą, o ile przerwa pomiędzy ustaniem poprzedniej
                    a powstaniem ponownej niezdolności do pracy, która jest spowodowana tą samą chorobą lub tą samą przyczyną nie przekraczała 60 dni.
                </font>
                <br /><br />
                <font size="3">
                    <b><i>Sekcja: Pozostałe informacje</i></b>
                </font>
                <br /><br />
                <font size="2">
                    Liczbę ubezpieczonych, ustala się według stanu na dzień 30 listopada poprzedniego roku kalendarzowego, a w stosunku do płatników składek, którzy na ten dzień
                    nie zgłaszali nikogo do ubezpieczenia chorobowego, według stanu na pierwszy miesiąc, w którym dokonali takiego zgłoszenia. 
                </font>
                <br /><br />
                <font size="3">
                    <b><i>Sekcja: Informacje o przychodzie</i></b>
                </font>
                <br /><br />
                <font size="2">
                    W tabeli w części dotyczącej przychodu stanowiącego podstawę wymiaru składek podaj kwoty niepomniejszone o składki na ubezpieczenia społeczne.
                    Pomniejszenia tego dokona ZUS podczas obliczania podstawy wymiaru zasiłku.
                    <br /><br />
                    <b>Wyjaśnienia dotyczące podstawy wymiaru zasiłku ubezpieczonych, o których mowa w sekcji: <i>Informacje o ubezpieczeniu</i> w pkt. 1–4 i 11</b>
                    <br /><br />
                    Podstawę wymiaru zasiłku stanowi przychód przyjęty do podstawy wymiaru składek na ubezpieczenie chorobowe albo odpowiednio ubezpieczenie wypadkowe,
                    po odliczeniu kwoty odpowiadającej 13,71% podstawy wymiaru składek, za okres 12 miesięcy kalendarzowych poprzedzających miesiąc, w którym powstała
                    niezdolność do pracy.<br />
                    Jeżeli wypłaciłeś ubezpieczonemu składniki przychodu za okresy dłuższe niż miesiąc (np. za okresy kwartalne, roczne lub inne), w sekcji <i>Uwagi</i>
                    podaj poszczególne kwoty i okresy, za które zostały wypłacone.<br />
                    W przypadku członków rolniczych spółdzielni produkcyjnych lub spółdzielni kółek rolniczych wyrównanie dniówek obrachunkowych wypłacane raz w roku
                    potraktuj jako składnik roczny i wykaż je w sekcji <i>Uwagi</i>.<br />
                    Jeśli ubezpieczony nie przepracował części miesiąca, za który przychód jest podany w tabeli, w sekcji <i>Uwagi</i> podaj przyczynę nieprzepracowania całego miesiąca.<br />
                    Podstawy wymiaru zasiłku nie ustala się na nowo, jeżeli między okresami pobierania zasiłków zarówno tego samego rodzaju, jak i innego rodzaju
                    nie było przerwy albo przerwa była krótsza niż 3 miesiące kalendarzowe. Jeżeli w związku z tym w tabeli podałeś przychód z innego okresu niż 12 miesięcy
                    kalendarzowych poprzedzających miesiąc, w którym powstała niezdolność do pracy, w sekcji <i>Uwagi</i> podaj poprzedni(e) okres(y) pobierania zasiłku
                    lub wynagrodzenia za okres choroby, pod warunkiem, że nie został(y) wykazany(e) w sekcji <i>Informacje o wypłaconych świadczeniach</i>.
                    <br /><br />
                    <b>Wyjaśnienie dotyczące ubezpieczonych, o których mowa w sekcji Informacje o ubezpieczeniu w pkt. 5–8 i 10</b>
                    <br /><br />
                    Podstawę wymiaru zasiłku chorobowego i świadczenia rehabilitacyjnego przysługującego po ustaniu ubezpieczenia wypadkowego stanowi przychód przyjęty do podstawy wymiaru składek
                    na ubezpieczenie wypadkowe, za okres 12 miesięcy poprzedzających datę powstania nieprzerwanej niezdolności do pracy, po odliczeniu kwoty odpowiadającej 11,26% podstawy wymiaru składki na to ubezpieczenie.
                    <br /><br />
                    <b>Wyjaśnienie dotyczące ubezpieczonych, o których mowa w sekcji Informacje o ubezpieczeniu w pkt. 9</b>
                    <br /><br />
                    Podstawę wymiaru zasiłku dla osoby odbywającej służbę zastępczą stanowi kwota świadczenia pieniężnego, określona w przepisach o służbie zastępczej za miesiąc, w którym powstała
                    niezdolność do pracy, po odliczeniu 13,71% tej kwoty.
                </font>
                <br /><br />
                <font size="3">
                    <b><i>Sekcja: Rachunek bankowy</i></b>
                </font>
                <br /><br />
                <font size="2">
                    Podaj, jeśli ubezpieczony wyraził wolę otrzymywania zasiłku na rachunek bankowy.
                    <br /><br />
                    <b>Ważne!<br />
                    Zaświadczenie płatnika składek złóż ponownie, jeśli zmieni się rodzaj pobieranego przez ubezpieczonego zasiłku. Nie dotyczy to świadczenia rehabilitacyjnego, jeżeli zaświadczenie płatnika składek złożyłeś do ustalenia prawa do zasiłku chorobowego.<br />
                    Poinformuj terenową jednostkę organizacyjną ZUS o okolicznościach, które mają wpływ na prawo, wysokość i podstawę wymiaru zasiłku, które uległy zmianie w stosunku do podanych w zaświadczeniu płatnika składek, w szczególności o ustaniu ubezpieczenia.<br />
                    Do wniosku o zasiłek chorobowy, zasiłek opiekuńczy, zasiłek macierzyński oraz świadczenie rehabilitacyjne dołącz otrzymane od ubezpieczonego dokumenty, określone w rozporządzeniu Ministra Rodziny, Pracy i Polityki Społecznej z 8 grudnia 2015 r. w sprawie zakresu informacji o okolicznościach mających wpływ na prawo do zasiłków z ubezpieczenia społecznego w razie choroby i macierzyństwa lub ich wysokość oraz dokumentów niezbędnych do przyznania i wypłaty zasiłków.</b>
                </font>
            </p>
            </ea:Section>
		    <ea:SectionMarker ID="SectionMarker8" runat="server" SectionType="GlobalFooter"></ea:SectionMarker>
		</form>
	</body>
</HTML>
